using System;
using System.Runtime.Serialization;

using Team_Project.Elements;

namespace Team_Project.Exceptions
{
	[Serializable]
	public class LockOverriddenException:TeamProjectException, ISerializable
	{
//		protected string server;
		protected LockElement newLock;
		public LockOverriddenException(LockElement newEl)
			:base("Lock has been taken by another user on another server")
		{
			newLock = newEl;
		}

		protected LockOverriddenException(SerializationInfo info, StreamingContext context):
			base(info,context)
		{
			newLock = new LockElement(info);
		}

//		public string ServerName
//		{
//			get{return server;}
//		}

		public LockElement OverriderLock
		{
			get{return newLock;}
		}

		#region ISerializable Members

		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info,context);
//			info.AddValue("server",server);
			newLock.Serialize(info);
		}

		#endregion
	}
}
